<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/settings/db.php';

if (!isset($_SESSION['memberId'])) {
    header("Location: home");
    exit;
}

$user_id = $_SESSION['memberId'];
$userCheckSite = $DB->prepare("SELECT * FROM users WHERE id = ?");
$userCheckSite->execute(array($user_id));
$userChk = $userCheckSite->fetch(PDO::FETCH_ASSOC);

$search = isset($_POST['search']) ? $_POST['search'] : '';

$productQuery = $DB->prepare("SELECT * FROM products WHERE ad LIKE ? OR category IN (SELECT id FROM category WHERE ad LIKE ?) OR productBarkod LIKE ?");
$searchTerm = "%{$search}%";
$productQuery->execute([$searchTerm, $searchTerm, $searchTerm]);
$products = $productQuery->fetchAll(PDO::FETCH_ASSOC);

?>

<?php foreach ($products as $productData): ?>
<tr class="odd">
<td class="sorting_1">
                                            #<?=$productData['id']?></a>
                                        </td>
                                        <td>
                                        <h6>
                                        <?php
if (isset($productData['category']) && $productData['category']) {
    $categoryId = $productData['category'];
    
    $stmt = $DB->prepare("SELECT ad FROM category WHERE id = ?");
    $stmt->execute([$categoryId]);
    $category = $stmt->fetch(PDO::FETCH_ASSOC);
if ($category && isset($category['ad'])) {
       echo $category['ad'];
    }
}
?>
</h6>
                                        </td>
										<td>
                                        <h6><?=$productData['ad']?></h6>
                                        </td>
                                        <td>
                                        <h6>
    <?php 
    $productDescriptions = $productData['productDesc'];
    $shortDesc = strlen($productDescriptions) > 55 ? wordwrap($productDescriptions, 55, "<br>", true) : $productDescriptions;
    echo nl2br($shortDesc);
    ?>
</h6></td>
                                        <td>
                                        <h6><?=$productData['productBarkod']?></h6>
                                        </td>
										<td>
                                        <h6><?=$productData['Fiyat']?>₺</h6>
                                        </td>
										<td>
                                        <h6><?=$productData['stock']?></h6>
                                        </td>
										<td>
										<div class="d-flex">
                                        <?php if ($userChk['pproductEdit'] == '1' || $userChk['isAdmin'] == '1') { ?>	
																		<a href="product/<?=$productData['id']?>" class="btn btn-primary shadow btn-xs sharp me-1"><i data-feather="edit-2" class="feather-icon-edit"></i></a>
																		<?php } ?>
                                                                        <?php if ($userChk['pproductDell'] == '1' || $userChk['isAdmin'] == '1') { ?>		
                                                                        <a id="productDell" productID="<?=$productData['id']?>" class="productDell btn btn-danger shadow btn-xs sharp"><i data-feather="trash-2" class="feather-icon-trash"></i></a>
                                                                        <?php } ?>
                                                                    </div></td>
									</tr>
<?php endforeach; ?>
<script>feather.replace();</script>
